IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST_EST_PROD_CPL_CARGA]'))
	DROP TRIGGER [dbo].[TRG_EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST_EST_PROD_CPL_CARGA]
GO

CREATE TRIGGER TRG_EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST_EST_PROD_CPL_CARGA ON EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST
AFTER INSERT, DELETE, UPDATE
AS

	IF CONTEXT_INFO() =  0x01010101
		RETURN;

     SET NOCOUNT ON;
	 /*
		Atualiza est_prod_cpl, para disparar o change tracking de carga.
	 */
	 BEGIN
         
         UPDATE C
           SET
               DT_ATUALIZA_PARAM = GETDATE()
         FROM INSERTED I
              INNER JOIN EST_PROD_CPL C ON I.CD_EMP = C.CD_EMP
                                           AND I.CD_PROD = C.CD_PROD
			  JOIN PRC_REGIAO_FISCAL_PRC_FILIAL F ON 
					I.CD_EMP = F.CD_EMP
				AND I.CD_REGIAO_FISCAL = F.CD_REGIAO_FISCAL
		WHERE
			F.CD_FILIAL = C.CD_FILIAL 
			AND  C.CD_EMP = F.CD_EMP 


     END;
GO
 